/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.event;

import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.entity.WindBladeEntity;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2library.capability.conditionals.ConditionalToken;
import java.util.function.BiConsumer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PandoraAttackListener
implements AttackListener {
    public void onCreateSource(CreateSourceEvent event) {
        Object object;
        if (event.getResult() != null && event.getResult().toRoot() == L2DamageTypes.PLAYER_ATTACK && (object = event.getAttacker()) instanceof Player) {
            Player player = (Player)object;
            for (ConditionalToken e : ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values()) {
                if (!(e instanceof IAttackListenerToken)) continue;
                IAttackListenerToken token = (IAttackListenerToken)e;
                token.onCreateSource(player, event);
            }
        }
    }

    public void setupProfile(AttackCache cache, BiConsumer<LivingEntity, ItemStack> profile) {
        WindBladeEntity e;
        Entity entity;
        LivingAttackEvent event = cache.getLivingAttackEvent();
        assert (event != null);
        Entity entity2 = event.getSource().m_7640_();
        if (entity2 instanceof WindBladeEntity && (entity = (e = (WindBladeEntity)entity2).m_19749_()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (!e.getStack().m_41619_()) {
                profile.accept(le, e.getStack());
            }
        }
    }

    public void onDamageFinalized(AttackCache cache, ItemStack weapon) {
        IAttackListenerToken token;
        Player player;
        LivingDamageEvent event = cache.getLivingDamageEvent();
        assert (event != null);
        if (event.getSource().m_269533_(L2DamageTypes.NO_SCALE)) {
            return;
        }
        Object object = cache.getAttackTarget();
        if (object instanceof Player) {
            player = (Player)object;
            object = ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values().iterator();
            while (object.hasNext()) {
                ConditionalToken e = (ConditionalToken)object.next();
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerDamagedFinal(player, cache);
            }
        }
        if ((object = cache.getAttacker()) instanceof Player) {
            player = (Player)object;
            for (ConditionalToken e : ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values()) {
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerDamageTargetFinal(player, cache);
            }
        }
    }

    public void onAttack(AttackCache cache, ItemStack weapon) {
        IAttackListenerToken token;
        Player player;
        LivingAttackEvent event = cache.getLivingAttackEvent();
        assert (event != null);
        Object object = cache.getAttackTarget();
        if (object instanceof Player) {
            player = (Player)object;
            for (ConditionalToken e : ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values()) {
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerAttacked(player, cache);
                if (!event.isCanceled()) continue;
                return;
            }
        }
        if (event.getSource().m_269533_(L2DamageTypes.NO_SCALE)) {
            return;
        }
        object = cache.getAttacker();
        if (object instanceof Player) {
            player = (Player)object;
            for (ConditionalToken e : ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values()) {
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerAttackTarget(player, cache);
            }
        }
    }

    public void onHurt(AttackCache cache, ItemStack weapon) {
        IAttackListenerToken token;
        Player player;
        LivingHurtEvent event = cache.getLivingHurtEvent();
        assert (event != null);
        if (event.getSource().m_269533_(L2DamageTypes.NO_SCALE)) {
            return;
        }
        Object object = cache.getAttacker();
        if (object instanceof Player) {
            player = (Player)object;
            object = ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values().iterator();
            while (object.hasNext()) {
                ConditionalToken e = (ConditionalToken)object.next();
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerHurtTarget(player, cache);
            }
        }
        if ((object = cache.getAttackTarget()) instanceof Player) {
            player = (Player)object;
            for (ConditionalToken e : ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values()) {
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerHurt(player, cache);
            }
        }
    }

    public void onDamage(AttackCache cache, ItemStack weapon) {
        IAttackListenerToken token;
        Player player;
        LivingDamageEvent event = cache.getLivingDamageEvent();
        assert (event != null);
        if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && !event.getSource().m_269533_(DamageTypeTags.f_268437_) && cache.getAttacker() != null && cache.getAttacker().m_21023_((MobEffect)CoPEffects.SHADOW.get())) {
            cache.addDealtModifier(DamageModifier.multTotal((float)((float)(1.0 - (Double)CoPConfig.COMMON.shadow.damageReduction.get()))));
        }
        if (event.getSource().m_269533_(L2DamageTypes.NO_SCALE)) {
            return;
        }
        Object object = cache.getAttacker();
        if (object instanceof Player) {
            player = (Player)object;
            object = ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values().iterator();
            while (object.hasNext()) {
                ConditionalToken e = (ConditionalToken)object.next();
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerDamageTarget(player, cache);
            }
        }
        if ((object = cache.getAttackTarget()) instanceof Player) {
            player = (Player)object;
            for (ConditionalToken e : ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.values()) {
                if (!(e instanceof IAttackListenerToken)) continue;
                token = (IAttackListenerToken)e;
                token.onPlayerDamaged(player, cache);
            }
        }
    }
}

